package com.android.browser;

import java.util.List;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class UserAgentReceiver extends BroadcastReceiver {

	private Controller controller;
	private static final String TAG = "UserAgentReceiver";

	/**
	 * Register receiver dynamically, not statically
	 * 
	 * @param activity
	 */
	public UserAgentReceiver(Controller controller) {
		if (controller != null) {
			this.controller = controller;
		} else {
			Log.e(TAG , "Inputted controller is null.");
		}
	}

	@Override
	public void onReceive(Context context, Intent intent) {
		
		if(this.controller == null){
			Log.e(TAG , "Inputted controller is null.");
			return;
		}

		Bundle extras = intent.getExtras();
		if (extras != null) {

			boolean isRemote = extras.getBoolean("desktop_browser");

			WebView web = controller.getCurrentWebView();

			if (web != null) {

				//controller.getSettings was made public so it could be accessed to be changed
				BrowserSettings settings = controller.getSettings();

				if (settings != null) {
					settings.setDesktopUserAgent(web, isRemote);
				}
					
				// reload page after mode is set
				web.loadUrl(web.getOriginalUrl());
				
				//Set User agent for all tabs, but DO NOT reload url
				List<Tab> tabs= controller.getTabs();
				for(Tab t: tabs){
					
					WebView webview = t.getWebView();
					WebSettings webSettings = webview.getSettings();
					if(isRemote){
						Log.i(TAG , "Setting user agent to the desktop user");
						webSettings.setUserAgent(1);
					}else{
						Log.i(TAG , "Setting user agent to mobile user");
						webSettings.setUserAgent(6);
					}
				}
					
			}

		}

	}

}
